package GUI;


import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import baseClass.Recomendacoes;

/**
 * @author Carlos Victor 
 */
public class MenuRecomendacoes implements MouseListener, ActionListener {

	private JFrame window = null;
	private JPanel panel1,panel2 = null;
	private JButton button2 = null;
	private JLabel label1,label2 = null;
	private Recomendacoes recomendacoes = null;
	private JButton button4,button3,button5,button6,button7 = null;
	private JLabel label6 = null;
	private String opinioesAux, enderecosAux;
	 
	/**
	 * Cria uma nova janela de sistema de recomendacoes
	 * @param opinioes
	 * 		O caminho do arquivo de opinioes.
	 * @param enderecos
	 * 		O caminho do arquivo de enderecos.
	 */
	public MenuRecomendacoes(String enderecos, String opinioes) {
		
		this.opinioesAux = opinioes;
		this.enderecosAux = enderecos;
			try {
				recomendacoes = new Recomendacoes(opinioes,enderecos);
			} catch (Exception e) {
				e.printStackTrace();
			}
		
		createWindow();
	}
	
	/**
	 * Criacao da janela.
	 */
	private void createWindow() {
		window = new JFrame();
		panel1 = new JPanel();
		panel2 = new JPanel();
		button3 = new JButton("Comparar algoritmos");
		button4 = new JButton("Recomendações.");
		button5 = new JButton("Semelhantes");
		button2 = new JButton("Voltar");
		button6 = new JButton("Filtrar estabelecimentos");
		button7 = new JButton("Ajuda");
		label2 = new JLabel("ESCOLHA UMA DAS OPÇÕES ABAIXO PARA INICIAR O SISTEMA.");
		label1 = new JLabel("");
		label6 = new JLabel(); 
		
		window.setSize(700, 600);
		window.setResizable(true);
		window.setMinimumSize(new Dimension(300, 200));
		window.setLocation(280, 60);
		window.setVisible(true);
		window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		label6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v3.png")));
		label6.setLocation(0, -150);
		label6.setSize(550,470);
		label1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/image3101-v3.png")));
		label1.setLocation(400, -150);
		label1.setSize(550, 470);
		label2.setLocation(170, -100);
		label2.setSize(650, 580);
		label2.setForeground(Color.WHITE);
		
		
		panel1.setVisible(true);
		panel1.setLayout(null);
		panel1.setBackground(Color.ORANGE);
		panel2.setVisible(true);
		panel2.setLayout(null);
		panel2.setLocation(80, 230);
		panel2.setSize(540, 250);
		panel2.setBackground(Color.WHITE);
		
		button2.setToolTipText("Voltar ao menu principal");
		button2.setEnabled(true);
		button2.addMouseListener(this);
		button2.addActionListener(this);
		button2.setSize(200,30);
		button2.setLocation(240, 500);
		button2.setForeground(Color.ORANGE);
		button3.setToolTipText("Comparar os algoritmos de recomendações existentes.");
		button3.setEnabled(true);
		button3.addMouseListener(this);
		button3.addActionListener(this);
		button3.setSize(200,30);
		button3.setLocation(50, 50);
		button3.setForeground(Color.WHITE);
		button3.setBackground(Color.ORANGE);
		button4.setToolTipText("Entrar no sistema de recomendações.");
		button4.setEnabled(true);
		button4.addMouseListener(this);
		button4.addActionListener(this);
		button4.setSize(200,30);
		button4.setLocation(300, 50);
		button4.setForeground(Color.WHITE);
		button4.setBackground(Color.ORANGE);
		button5.setToolTipText("Verifica os usuários com opiniões semelhantes");
		button5.setEnabled(true);
		button5.addMouseListener(this);
		button5.addActionListener(this);
		button5.setSize(200,30);
		button5.setLocation(300, 150);
		button5.setForeground(Color.WHITE);
		button5.setBackground(Color.ORANGE);
		button6.setToolTipText("Filtrar os estabelecimentos");
		button6.setEnabled(true);
		button6.addMouseListener(this);
		button6.addActionListener(this);
		button6.setSize(200,30);
		button6.setLocation(50, 150);
		button6.setForeground(Color.WHITE);
		button6.setBackground(Color.ORANGE);
		button7.setToolTipText("Saiba como usar");
		button7.setEnabled(true);
		button7.addMouseListener(this);
		button7.addActionListener(this);
		button7.setSize(80,30);
		button7.setLocation(600, 520);
		button7.setForeground(Color.ORANGE);
		
		
		panel2.add(button3);
		panel2.add(button4);
		panel2.add(button5);
		panel2.add(button6);
		
		panel1.add(button2);
		panel1.add(button7);
		panel1.add(label1);
		panel1.add(label2);
		panel1.add(panel2);
		panel1.add(label6);
		
		window.add(panel1);
	}

	/**
	 * M�todos referentes ao MouseListenner
	 */
	public void mouseClicked(MouseEvent arg0) {
	}

	public void mouseEntered(MouseEvent arg0) {
	}
	
	public void mouseExited(MouseEvent arg0) {
	}

	public void mousePressed(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

	/**
	 * Metodo referente ao ActionListener
	 */
	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource() == button2) {
			window.setVisible(false);
			new MenuPrincipal(enderecosAux, opinioesAux).setVisible(true);
		}
		
		if (e.getSource() == button3) {
			window.setVisible(false);
			new JanelaComparacao(recomendacoes);
		}
		
		if (e.getSource() == button4) {
				window.setVisible(false);
				new JanelaRecomendacoes(recomendacoes);	
		}
		
		if (e.getSource() == button5) {
			window.setVisible(false);
			new JanelaSemelhantes(recomendacoes);
		}
		
		if (e.getSource() == button6) {
			window.setVisible(false);
			new JanelaFiltros(recomendacoes);
		}
		button3 = new JButton("Comparar algoritmos");
		button4 = new JButton("Recomendações.");
		button5 = new JButton("Semelhantes");
		button2 = new JButton("Voltar");
		button6 = new JButton("Filtrar estabelecimentos");
		
		if (e.getSource() == button7) {
			JOptionPane.showMessageDialog(null, "SEJA BEM VINDO, APRENDA A USAR O MENU DE RECOMENDAÇÕES.\nSISTEMA DE RECOMENDAÇÕES - você irá entrar no sistema de recomendações que contém 3 algoritmos de recomendações\nFILTRAR ESTABELECIMENTOS - você pode escolher entre duas formas de ordenação dos estabelecimentos\nSEMELHANTES - você poderá verificar as opiniões dos usuários que possuem o perfil mais semelhante ao seu\nCOMPARAR ALGORITMOS - você terá acesso ao índice de acertos dos algoritmos de recomendações global e personalizado.");					
		}
	}
}
